//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Threading;
using System.Diagnostics;


namespace QueueUserWorkItem
{
	public class Fibonacci 
	{
		private	long fibnumber;
		private long result;
		private long startTime;
		private long stopTime;
		private long fib(long x) 
		{
			return ((x<=1)?1:(fib(x-1)+fib(x-2)));
		}
		public Fibonacci(long num)
		{
			fibnumber = num;
			startTime = 0;
			stopTime = 0;
		}
		public void Start()
		{
			startTime = Environment.TickCount;
		}
		public void Stop()
		{
			stopTime = Environment.TickCount;
		}
		public long Elapsed
		{
			get
			{
				return stopTime - startTime;
			}
		}
		public void Compute(Object o)
		{
			result = fib(fibnumber);
			Stop();
			QueueUserWorkItemForm form = (QueueUserWorkItemForm)o;
			form.BeginInvoke(form.Results, new object[]{fibnumber, result, Elapsed});
			fibnumber++;
			if(fibnumber < 40)
			{
				Start();
				ThreadPool.QueueUserWorkItem(new WaitCallback(Compute), o);
			}
		}
	}
	public class QueueUserWorkItemForm : System.Windows.Forms.Form
	{
		private System.Windows.Forms.ListView fibonacciList;
		private System.Windows.Forms.ColumnHeader index;
		private System.Windows.Forms.ColumnHeader fibonacciNumber;
		public delegate void FibonacciResultsDelegate(long number, long result, long elapsed);
		private FibonacciResultsDelegate fibonacciResultsDelegate;
		private System.Windows.Forms.ColumnHeader elapsedTime;
		private System.Windows.Forms.Button startButton;
		/// <summary>
		/// Wymagana zmienna.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public QueueUserWorkItemForm()
		{
			//
			// Wymagane do obsugi Windows Form Designer
			//
			InitializeComponent();
		}
		public FibonacciResultsDelegate Results
		{
			get
			{
				return fibonacciResultsDelegate;
			}
		}

		private void OnFibonacciResults(long number, long result, long elapsed)
		{
			ListViewItem item = new ListViewItem(Convert.ToString(number));
			item.SubItems.Add(Convert.ToString(result));
			item.SubItems.Add(Convert.ToString(elapsed));
			fibonacciList.Items.Add(item);
		}

		/// <summary>
		/// Oczyszczenie uywanych zasobw.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Metoda wymagana do obsugi Designera - nie naley modyfikowa
		/// zawartoci tej metody przy uyciu edytora kodu.
		/// </summary>
		private void InitializeComponent()
		{
			this.fibonacciList = new System.Windows.Forms.ListView();
			this.index = new System.Windows.Forms.ColumnHeader();
			this.fibonacciNumber = new System.Windows.Forms.ColumnHeader();
			this.elapsedTime = new System.Windows.Forms.ColumnHeader();
			this.startButton = new System.Windows.Forms.Button();
			this.SuspendLayout();
			// 
			// fibonacciList
			// 
			this.fibonacciList.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																							this.index,
																							this.fibonacciNumber,
																							this.elapsedTime});
			this.fibonacciList.Location = new System.Drawing.Point(8, 8);
			this.fibonacciList.Name = "fibonacciList";
			this.fibonacciList.Size = new System.Drawing.Size(344, 248);
			this.fibonacciList.TabIndex = 0;
			this.fibonacciList.View = System.Windows.Forms.View.Details;
			// 
			// index
			// 
			this.index.Text = "Indeks";
			// 
			// fibonacciNumber
			// 
			this.fibonacciNumber.Text = "Liczba Fibonacciego";
			this.fibonacciNumber.Width = 180;
			// 
			// elapsedTime
			// 
			this.elapsedTime.Text = "Upyno";
			this.elapsedTime.Width = 99;
			// 
			// startButton
			// 
			this.startButton.Location = new System.Drawing.Point(8, 272);
			this.startButton.Name = "startButton";
			this.startButton.TabIndex = 1;
			this.startButton.Text = "Start";
			this.startButton.Click += new System.EventHandler(this.OnStart);
			// 
			// QueueUserWorkItemForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(360, 373);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.startButton,
																		  this.fibonacciList});
			this.Name = "QueueUserWorkItemForm";
			this.Text = "Test QueueUserWorkItem";
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// Gwny punkt wejcia dla aplikacji.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new QueueUserWorkItemForm());
		}

		private void OnStart(object sender, System.EventArgs e)
		{
			fibonacciList.Items.Clear();
			fibonacciResultsDelegate = new FibonacciResultsDelegate(OnFibonacciResults);
			Fibonacci fib = new Fibonacci(0);
			try 
			{
				fib.Start();
				ThreadPool.QueueUserWorkItem(new WaitCallback(fib.Compute), this);
			}
			catch (NotSupportedException) 
			{
				Debug.WriteLine("Przechwycono wyjtek NotSupportedException, poniewa: ");
				Debug.WriteLine("\tSystem.ThreadPool.QueueUserWorkItem nie jest obsugiwany na tym systemie.");
				Debug.WriteLine("\tKonieczno uruchomienia w systemie Win2K lub uycia dodatkowej obsugi Win32");
			}
		}
	}
}
